
#rm(list=ls())
library(glmnet) 
library(ncvreg) 

library(MASS)
#n2: test size
#x: n x p design matrix 
#r: repetitions 
cv.compare<-function(x,y,n2,r){
  n<-nrow(x)
  err.r<-rep(0,r)
  err.l<-rep(0,r)
  err.e<-rep(0,r)
  err.m<-rep(0,r)
  err.s<-rep(0,r)
  for (i in 1:r) {
    train=sample(1:n, n-n2)
    test=(-train)
    y.test=y[test]
    
    ridge.mod=glmnet(x[train,],y[train],alpha=0)  
    cv.out=cv.glmnet(x[train,],y[train],alpha=0)  
    ridge.pred=predict(ridge.mod,s=cv.out$lambda.min,newx=x[test,])
    err.r[i]=mean((ridge.pred-y.test)^2)
    
    lasso.mod=glmnet(x[train,],y[train],alpha=1)
    cv.out.l=cv.glmnet(x[train,],y[train],alpha=1)  
    lasso.pred=predict(lasso.mod,s=cv.out.l$lambda.min,newx=x[test,])
    err.l[i]=mean((lasso.pred-y.test)^2)
    
    elas.mod=glmnet(x[train,],y[train],alpha=0.9)
    cv.out.e=cv.glmnet(x[train,],y[train],alpha=0.9)  
    elas.pred=predict(elas.mod,s=cv.out.e$lambda.min,newx=x[test,])
    err.e[i]=mean((elas.pred-y.test)^2)
    
    mcp.mod <- cv.ncvreg(x[train,],y[train],family='gaussian',penalty='MCP',nfolds=5)
    mcp.pred <- predict(mcp.mod,X=x[test,],lambda=mcp.mod$lambda.min)
    err.m[i]=mean((mcp.pred-y.test)^2)
    
    scad.mod <- cv.ncvreg(x[train,],y[train],family='gaussian',penalty='SCAD',nfolds=5)
    scad.pred <- predict(scad.mod,X=x[test,],lambda=scad.mod$lambda.min)
    err.s[i]=mean((scad.pred-y.test)^2)
  }

  c(ridge.err=mean(err.r),ridge.sd=sd(err.r),lasso.err=mean(err.l),lasso.sd=sd(err.l), elas.err=mean(err.e),elas.sd=sd(err.e),mcp.err=mean(err.m),mcp.sd=sd(err.m), scad.err=mean(err.s),scad.sd=sd(err.s))		
}
 

 